(function($) {
    "use strict";
    $.fn.countdown = function(options) {
        var defaults = {
            until: '',
            layout: '<span class="box-count day"><span class="number">0</span><span class="text">Days</span></span><span class="box-count hrs"><span class="number">0</span><span class="text">Hrs</span></span><span class="box-count min"><span class="number">0</span><span class="text">Mins</span></span><span class="box-count secs"><span class="number">0</span> <span class="text">Secs</span></span>',
            leadingZero: true,
            countStepper: -1, // s: -1 // min: -60 // hour: -3600
            timeout: '<span class="timeout">Time out!</span>',
        };

        var settings = $.extend(defaults, options),
            until = settings.until,
            layout = settings.layout,
            leadingZero = settings.leadingZero,
            countStepper = settings.countStepper,
            setTimeOutPeriod = (Math.abs(countStepper) - 1) * 1000 + 990,
            timeout = settings.timeout;

        var methods = {
            init: function() {
                return this.each(function() {
                    var $countdown = $(this);
                    if ($countdown.length && !$countdown.hasClass('init')) {
                        $countdown.addClass('init');
                        methods.timerLoad($countdown);
                    }
                });
            },

            timerLoad: function(el) {
                var gsecs = (new Date(until).getTime() > 0) ? until : el.data('timer');
                if (typeof gsecs === 'string') gsecs = gsecs.replace(/-/g, '/');
                if (isNaN(gsecs) || typeof gsecs === 'object') {
                    var start = Date.parse(new Date());
                    var end = isNaN(gsecs) ? Date.parse(gsecs) : gsecs;
                    var end = (typeof gsecs === 'object') ? gsecs : Date.parse(gsecs);
                    gsecs = (end - start) / 1000;
                }
                if (gsecs > 0) {
                    var isLayout = el.find('.min .number');
                    if (!isLayout.length) {
                        el.html(layout);
                    }
                    methods.CountBack(el, gsecs);
                } else {
                    el.html(timeout);
                }
            },

            calcage: function(secs, num1, num2) {
                var s = ((Math.floor(secs / num1) % num2)).toString();
                if (leadingZero && s.length < 2) s = "0" + s;
                return "<b>" + s + "</b>";
            },

            CountBack: function(el, secs) {
                var count = setInterval(function timer() {
                    if (secs < 0) {
                        clearInterval(count);
                        el.html(timeout);
                        return;
                    }
                    el.find('.day .number').html(methods.calcage(secs, 86400, 100000));
                    el.find('.hour .number, .hrs .number').html(methods.calcage(secs, 3600, 24));
                    el.find('.min .number').html(methods.calcage(secs, 60, 60));
                    el.find('.sec .number, .secs .number').html(methods.calcage(secs, 1, 60));
                    secs += countStepper;
                    return timer;
                }(), setTimeOutPeriod);
            }

        };

        if (methods[options]) {
            return methods[options].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof options === 'object' || !options) {
            return methods.init.apply(this);
        } else {
            $.error('Method "' + method + '" does not exist in timer plugin!');
        }
    };

})(jQuery);